--------------------------------------------
--
-- APELLIDOS:
--
-- NOMBRE:
--
-- PUESTO:
--
--------------------------------------------
type Posicin = Int
busca :: String -> String -> [Posicin]
{- 
busca as bs = la lista de todas las posiciones donde comienza la secuencia as 
dentro de la secuencia bs 
-}

busca [] bs = []
busca ps bs = buscaPrefijosDesde 1 ps bs


buscaPrefijosDesde :: Int -> String -> String -> [Posicin]

buscaPrefijosDesde _   _  []         = []
buscaPrefijosDesde pos as bs@(b:bs') =
                [ pos | prefijo as bs ] ++
                buscaPrefijosDesde (pos+1) as bs'

prefijo :: String -> String -> Bool
prefijo []     _      = True
prefijo _      []     = False
prefijo (a:as) (b:bs) = a==b && prefijo as bs


--- B Qu computa la siguiente funcin
sorpresa :: [[a]] -> [[a]]  
sorpresa [f] = map (\x -> [x]) f
sorpresa (f:fs) = pegar f ([]:sorpresa fs)

pegar []     ds      = ds
pegar (a:as) (d:ds)  = (d++[a]) : pegar as ds

-- sorpresa calcula las diagonales principales

miTabla = [[1..5], [2..6], [3..7]]

miSopa = [ "casacasa", "aapesaxx", "mxxaxxxx"]

misPalabras = [ "casa","saco","mas","pesa" ]

diags = sorpresa


-- C

apariciones sopa =
   filter (\p -> [] /= concat [ busca p l | l<- sopa ++ diags sopa ])

p1 = apariciones miSopa misPalabras

apariciones2 sopa =
  map (\p ->  (p, (length . concat) [ busca p l | l<- sopa ++ diags sopa ]) )

p2 = apariciones2 miSopa misPalabras
